/* COPYRIGHT:                                                                 */
/* ----------                                                                 */
/*  (C) Copyright International Business Machines Corporation 1992            */
/*  IBM DAPTOOLS USE ONLY.                                                  */

#define INCL_WINFRAMEMGR                /* relevant parts of         */
#define INCL_WINSYS                     /* the PM header file        */
#define INCL_WINHOOKS                   /* Hooks.                    */
 typedef struct ErrorMsgTable{
       unsigned long retcode;
       char     *    reason;
       } ErrorMsgTable ;

#define INCL_WINHELP                    /* include IPF header file          */

#include <os2.h>                        /* PM header file                   */
#include <string.h>                     /* C/2 string functions             */
#include <stdio.h>                      /* C/2 sprint function.             */

char errror_error[1024];


/***************************************************************/
/*          HELP ERROR TABLE changes return code to text.      */
/***************************************************************/

  /* The help error table translates the number that is send in
   ulErrorCode to the text in the message. it is just a hack of
     PMHELP.H .

     I have left the form of it the same as pmhelp.h so you can see
     how I maded the help tables. It can be used with many others.
     Below is a copy of one of the pmhelp.h entrys i took.
                                       AVCruise. 7/22/92 */
/* Example follows. VVVVVVVVVV */
/******************************************************************************/
/* HMERR_NO_FRAME_WND_IN_CHAIN - There is no frame window in the              */
/* window chain from which to find or set the associated help                 */
/* instance.                                                                  */
/******************************************************************************/
#define  HMERR_NO_FRAME_WND_IN_CHAIN                0x00001001L
/* AAAAAAAAAAAAAAAAAAAAAAAAAA */

   ErrorMsgTable helperrortable[] = {
   0x00001001L,
 " HMERR_NO_FRAME_WND_IN_CHAIN - There is no frame window in the"
 " window chain from which to find or set the associated help"
 " instance."

 , 0x00001002L,
 " HMERR_INVALID_ASSOC_APP_WND - The application window handle"
 " specified on the WinAssociateHelpInstance() call is not a valid"
 " window handle."

 , 0x00001003L,
 " HMERR_INVALID_ASSOC_HELP_INST - The help instance handle specified"
 " on the WinAssociateHelpInstance() call is not a valid"
 " window handle."

 , 0x00001004L,
 " HMERR_INVALID_DESTROY_HELP_INST - The window handle specified"
 " as the help instance to destroy is not of the help instance class."

 , 0x00001005L,
 " HMERR_NO_HELP_INST_IN_CHAIN - The parent or owner chain of the"
 " application window specified does not have a help instance"
 " associated with it."

 , 0x00001006L,
 " HMERR_INVALID_HELP_INSTANCE_HDL - The handle specified to be a"
 " help instance does not have the class name of a IPF"
 " help instance."

 , 0x00001007L,
 " HMERR_INVALID_QUERY_APP_WND - The application window specified on"
 " a WinQueryHelpInstance() call is not a valid window handle."

 , 0x00001008L,
 " HMERR_HELP_INST_CALLED_INVALID -  The handle of the help instance"
 " specified on an API call to the IPF does not have the"
 " class name of an IPF help instance."

 , 0x00001009L,
 "  HMERR_HELPTABLE_UNDEFINE"
 " - The application did not provide a help table for"
 "context-sensitive help."

 , 0x0000100aL,
 "  HMERR_HELP_INSTANCE_UNDEFINE"
 " - The help instance handle specified is invalid."

 , 0x0000100bL,
 "  HMERR_HELPITEM_NOT_FOUND"
 " - Context-sensitive help was requested but the ID of the"
 " main help item specified was not found in the help table."

 , 0x0000100cL,
 "  HMERR_INVALID_HELPSUBITEM_SIZE"
 " - The help subtable item size is less than 2."

 , 0x0000100dL,
 "  HMERR_HELPSUBITEM_NOT_FOUND"
 " - Context-sensitive help was requested but the ID of the"
 " help item specified was not found in the help subtable."

 , 0x00002001L,
 " HMERR_INDEX_NOT_FOUND - No index in library file."

 , 0x00002002L,
 " HMERR_CONTENT_NOT_FOUND - Library file does not have any contents."

 , 0x00002003L,
 " HMERR_OPEN_LIB_FILE     - Cannot open library file."

 , 0x00002004L,
 " HMERR_READ_LIB_FILE     - Cannot read library file."

 , 0x00002005L,
 " HMERR_CLOSE_LIB_FILE    - Cannot close library file."

 , 0x00002006L,
 " HMERR_INVALID_LIB_FILE  - Improper library file provided."

 , 0x00002007L,
 " HMERR_NO_MEMORY - Unable to allocate the requested amount of memory."

 , 0x00002008L,
 " HMERR_ALLOCATE_SEGMENT - Unable"
 " to allocate a segment of memory for memory allocation requested"
 " from the IPF."

 , 0x00002009L,
 " HMERR_FREE_MEMORY - Unable to free allocated  memory."

 , 0x00002010L,
 " HMERR_PANEL_NOT_FOUND  - Unable"
 " to find a help panel requested to IPF."

 , 0x00002011L,
 " HMERR_DATABASE_NOT_OPEN - Unable to read the unopened database."
 ,9999,""    /* end marker (not perfect but good for examples.) */
};

/*****************************************************************/
    char  *LastEntry[]={
        "Menu"
       ,"Frame"
       ,"Window"
         };
/*****************************************************************/
static   USHORT usLastMode;
static   USHORT idTopicMenu,  idSubTopicMenu     = 0;
static   USHORT idTopicFrame, idSubTopicFrame    = 0;
static   USHORT idTopicWindow,idSubTopicWindow   = 0;

/*****************************************************************/
/* do a table search and if found return the text. if not found  */
/* return a string with the input value for error code.          */
/* All of the above tables have a end marker of 9999,""          */
/* so if can be used as the second parm to the "for",            */
/* rather then sizeof.                                           */
/*****************************************************************/
char * error_msg_table(ErrorMsgTable *errortable,
                       unsigned long  errorcode){
          int i;
          for (i=0;errortable[i].retcode!=9999 ; i++) {
             if (errortable[i].retcode == errorcode)
                 return errortable[i].reason;
          } /* endfor */
          sprintf(errror_error,"Error not Known. errorcode = <%x>."
                               ,errorcode);
          return errror_error;
       }


/*******Main Logic.***********************************************/
/* This routine has two uses.                                    */
/* Save the current help request.                                */
/* Display the help information if there is an help error.       */
/*                                                                */
/* I will discribe them in reverse order for ease of understanding.*/
/* 2nd is the help hook. We save the information about the       */
/* current request for help and then pass the request on.        */
/* There are 3 modes  (menu, frame, window) we can therefor      */
/* save the information in 3 sets of data.                       */
/*                                                               */
/* And 1st.                                                      */
/* If we have a help error,it call this same hook with a         */
/* Topic of 9991. IF we see the 9991 we put up a message         */
/* with the information that we got from the above routine.      */
/*                                                               */
/* NB. We return a False to say to help to keep looking.         */
/*****************************************************************/


BOOL EXPENTRY MyHelpHook(
                     HAB     hab
                    ,USHORT  usMode
                    ,USHORT  idTopic
                    ,USHORT  idSubTopic
                    ,PRECTL  prcPositon){
   /* Are we here for help on help errors. */
   if (idTopic ==  9991) {
                   /* This is the help for help Errors.  */
                   /* so we must show the mode, topic and subtopic */

          sprintf(errror_error,"Help Error Help \n"
                               "Last Mode Entry was [%s] <%d>\n"
                               "For Menu: \n"
                               " Last SubMenu      id was %u \n"
                               " Last item         id was %u.\n"
                               "For Frame: \n"
                               " Last frame        id was %u \n"
                               " Last focus-window id was %u.\n"
                               "For Window: \n"
                               " Last parent-window   was %u \n"
                               " Last focus-window id was %u.\n"
                               ,LastEntry[usLastMode]
                               ,usLastMode
                               ,idTopicMenu,idSubTopicMenu
                               ,idTopicFrame,idSubTopicFrame
                               ,idTopicWindow,idSubTopicWindow
                               );

        WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
                     errror_error,
                     (PSZ) "Help Error Help",
                  9999,MB_OK
                     | MB_APPLMODAL
                      | MB_MOVEABLE);
         }; /* if (idTopic ==  9991)  */

  /* this is where we save the mode topic and subtopic */

    switch(usMode){
       case HLPM_MENU: {
            /* we have a menu item asking for help. save it.*/
          usLastMode     = 0     ;
          idTopicMenu    = idTopic;
          idSubTopicMenu = idSubTopic;
          break; }

       case HLPM_FRAME: {
            /* we have a menu item asking for help. save it.*/
          usLastMode      = 1;
          idTopicFrame    = idTopic;
          idSubTopicFrame = idSubTopic;
          break;   }

       case HLPM_WINDOW: {
            /* we have a Frame item asking for help. save it.*/
          usLastMode       = 2;
          idTopicWindow    = idTopic;
          idSubTopicWindow = idSubTopic;
          break;   }
}  /* switch usMode */

  /* this says to continue down the chain looking for help. */
   return FALSE;
};
